{*****************************************************************************
*
* Module:      COLOURLISTBOX.PAS
*
* Author:      S Wloch
* Date:        18-04-1997
* Version:     1.01
*
* Environment: Delphi 2.0 & 3.0
* Compiler:
* Target:      WINDOWS 95 & WINDOWS NT
*
*-----------------------------------------------------------------------------
* Description: TColourListBox Component
*-----------------------------------------------------------------------------
* Modifications:
*
* Date      By       Description
* --------------------------------------------------------------------
* 01-07-97  SW       Change colour of highlighted text to a lighter colour if
*                    highlight background is a dark colour.  In previous version,
*                    difficult to see highlighted text if both text colour and
*                    highlight background dark colours.
*
******************************************************************************}

unit colourlistbox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TColourListBox = class(TListBox)
  protected
     function GetItemColour(ndx: Integer): LongInt;
     procedure SetItemColour(ndx: Integer; val: LongInt);
  public
     constructor Create(AOwner: TComponent); override;
     property ItemColour[ndx: Integer]: LongInt read GetItemColour write SetItemColour;
  published
     procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TColourListBox]);
end;

constructor TColourListBox.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     Style:=lbOwnerDrawVariable;
end;

function TColourListBox.GetItemColour(ndx:Integer):longint;
begin
     GetItemColour:=SendMessage(handle, LB_GETITEMDATA, ndx, 0);
end;

procedure TColourListBox.SetItemColour(ndx:Integer; val:longint);
begin
     SendMessage(handle, LB_SETITEMDATA, ndx, val);
end;

procedure TColourListBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
   Col: Tcolor;

begin
     Col:=ItemColour[Index];
     if odSelected in State then
        Col:=Col XOR $00FFFFFF;

     Canvas.Font.Color:=Col;
     Canvas.FillRect(Rect);
     Canvas.MoveTo(Rect.Left+2, Rect.Top);
     SetTextAlign(Canvas.Handle, TA_LEFT OR TA_UPDATECP);
     if Index < Items.Count then
        Canvas.TextOut(Rect.Left + 2, Rect.Top, Items[Index]);
end;

end.
